#!/usr/bin/python
# -*- coding: utf-8 -*-

#
# Logik verze 1.0.1, Copyright (C) 2006 Jan Fuchs
#
# Logik je ABSOLUTNĚ BEZ ZÁRKUKY. Jde o volné programové vybavení a jeho šíření
# za jistých podmínek je vítáno; podrobnosti získáte v Obecné veřejné licenci
# GNU.
#

import Tkinter
import random

platno = None
pozice = None
run = False
kod = []
tip = []
pole = []
barva = [ "white", "black", "red", "green", "blue", "yellow" ]

SIZE_BIG = 50
SIZE_SMALL = 25

WIDTH = 400
HEIGHT = 800

def paint(x, y, size, color):
  x = x * size + 5
  y = y * size + 5
  
  platno.create_oval(x, y, x + size - 10, y + size - 10, fill=color)

def mrizka(x, y, posun_x, posun_y, size):
  x1 = posun_x
  x2 = size * x + posun_x
  
  for i in range(0, y +1):
    y1 = size * i + posun_y
    y2 = y1
    platno.create_line(x1, y1, x2, y2, fill="black")
    
  y1 = posun_y
  y2 = size * y + posun_y
  for i in range(0, x + 1):
    x1 = size * i + posun_x
    x2 = x1
    platno.create_line(x1, y1, x2, y2, fill="black")

def start(event):
  global run, pozice, kod, tip

  for i in range(10):
    pole.append([0, 0, 0, 0])
  
  platno.create_rectangle(0, 0, WIDTH, HEIGHT, fill="white")

  mrizka(2, 20, 50, 150, SIZE_SMALL)
  mrizka(6, 1, 50, 50, SIZE_BIG)
  mrizka(4, 10, 150, 150, SIZE_BIG)
  mrizka(4, 1, 150, 700, SIZE_BIG)

  paint(1, 1, SIZE_BIG, barva[0])
  paint(2, 1, SIZE_BIG, barva[1])
  paint(3, 1, SIZE_BIG, barva[2])
  paint(4, 1, SIZE_BIG, barva[3])
  paint(5, 1, SIZE_BIG, barva[4])
  paint(6, 1, SIZE_BIG, barva[5])
  
  kod = [-3, -3, -3, -3]
  tip = [-4, -4, -4, -4]
  for i in range(4):
    kod[i] = random.randrange(0, 5)
  #kod = [0, 4, 2, 3]
  pozice = 0
  run = True
    
def click(event):
  global run, pozice, tip

  x = event.x / 50
  y = event.y / 50
    
  if (run and (x > 0) and (x < 7) and (y == 1)):
    x -= 1
    radek = pozice / 4
    sloupec = pozice % 4
    tip[sloupec] = x
    paint(sloupec + 3, radek + 3, SIZE_BIG, barva[x])

    bily = 0
    cerny = 0
    kod_tmp = []
    kod_tmp.extend(kod)
    if (sloupec == 3):
      for i in range(4):
        if (kod_tmp[i] == tip[i]):
          kod_tmp[i] = -1
          tip[i] = -2
          bily += 1

      for i in range(4):
        for j in range(4):
          if (kod_tmp[j] == tip[i]):
            kod_tmp[j] = -1
            tip[i] = -2
            cerny += 1
            break
      
      color = "white"
      for i in range(1, bily + cerny + 1):
        if (i > bily):
          color = "black"
          
        if (i == 1):
          paint(2, 6 + radek * 2, SIZE_SMALL, color)
        elif (i == 2):
          paint(3, 6 + radek * 2, SIZE_SMALL, color)
        elif (i == 3):
          paint(2, 7 + radek * 2, SIZE_SMALL, color)
        elif (i == 4):
          paint(3, 7 + radek * 2, SIZE_SMALL, color)

    if ((sloupec == 3) and (bily == 4)):
      platno.create_text(WIDTH / 2, 30, font=("system-dependent", 20), text="Victory", fill="black")
      run = False

    if (pozice == 39):
      platno.create_text(WIDTH / 2, 30, font=("system-dependent", 20), text="Loss", fill="red")
      run = False

    if (not run):
      for i in range(4):
        paint(3 + i, 14, SIZE_BIG, barva[kod[i]])
  
    pozice += 1
    
def main():
  global platno, pole
  
  okno = Tkinter.Tk()
  okno.wm_title("Logik 1.0")
  
  platno = Tkinter.Canvas(okno, width=WIDTH, height=HEIGHT, background="white")
  platno.bind("<Button-1>", click)
  platno.bind("<Button-3>", start)
  platno.pack()
  
  platno.create_text(WIDTH / 2, 200, font=("system-dependent", 60), text="Logik", fill="black")
  platno.create_text(WIDTH / 2, 300, font=("system-dependent", 10), text="Mouse button 3 = new game", fill="black")
  
  okno.mainloop()

if __name__ == '__main__':
  main()
